# vim: set expandtab ts=4 sw=4:

# === UCSF ChimeraX Copyright ===
# Copyright 2016 Regents of the University of California.
# All rights reserved.  This software provided pursuant to a
# license agreement containing restrictions on its disclosure,
# duplication and use.  For details see:
# http://www.rbvi.ucsf.edu/chimerax/docs/licensing.html
# This notice must be embedded in or attached to all copies,
# including partial copies, of the software or any revisions
# or derivations thereof.
# === UCSF ChimeraX Copyright ===

# import distutils.core
# distutils.core.DEBUG = True
# TODO: remove distlib monkey patch when the wheel package
# implements PEP 426's pydist.json
from distlib import metadata
metadata.METADATA_FILENAME = "metadata.json"
from setuptools import setup

description = """
The ChimeraX-Log bundle provides a tool for viewing a log of what
the user has done.
"""

setup(
    name="ChimeraX-Log",
    version="1.0",  # PEP 440, should match Development Status below
    description="Log support",  # one line synopsis
    long_description=description,  # see above
    author="UCSF RBVI",
    author_email="chimerax@cgl.ucsf.edu",
    url="https://www.rbvi.ucsf.edu/chimerax/",
    python_requires=">= 3.5",
    package_dir={
        "chimerax.log": "src",    # directory package's source files are in
    },
    packages=[
        "chimerax.log",
    ],
    install_requires=[
        "ChimeraX-Core >= 0.1",
    ],
    classifiers=[
        # From https://pypi.python.org/pypi?%3Aaction=list_classifiers
        # and our own ChimeraX classifiers.
        "Development Status :: 5 - Production/Stable",
        "Environment :: MacOS X :: Aqua",
        "Environment :: Win32 (MS Windows)",
        "Environment :: X11 Applications",
        "Framework :: ChimeraX",
        "Intended Audience :: Science/Research",
        "License :: Free for non-commercial use",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows :: Windows 10",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering :: Visualization",
        "Topic :: Scientific/Engineering :: Chemistry",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        "ChimeraX :: Bundle :: General :: 1,1 :: chimerax.log :: chimerax.log :: ",
        "ChimeraX :: Tool :: Log :: General :: Log of information and output",
        "ChimeraX :: Command :: echo :: General :: Log a line of text",
        "ChimeraX :: Command :: log :: General :: manipulate the Log tool",
    ],
)
