from PyQt6.QtWidgets import QApplication, QWidget, QLabel, QComboBox, QVBoxLayout

# Only needed for access to command line arguments
import sys

# You need one (and only one) QApplication instance per application.
# Pass in sys.argv to allow command line arguments for your app.
# If you know you won't use command line arguments QApplication([]) works too.
app = QApplication(sys.argv)

# Create a Qt widget, which will be our window.
window = QWidget()
layout = QVBoxLayout()
window.setLayout(layout)
layout.addWidget(QLabel("Test case"))
class DebuggingQComboBox(QComboBox):
	def dragEnterEvent(self, event):
		print("dragEnterEvent", file=sys.__stderr__)
		event.acceptProposedAction()
		return super().dragEnterEvent(event)

	def dragLeaveEvent(self, event):
		print("dragLeaveEvent", file=sys.__stderr__)
		return super().dragLeaveEvent(event)

	def dropEvent(self, event):
		print("dropEvent", file=sys.__stderr__)
		return super().dropEvent(event)

combo_box = DebuggingQComboBox(window)
combo_box.setAcceptDrops(True)
combo_box.setEditable(True)
#combo_box.lineEdit().setText("initial text")
layout.addWidget(combo_box)
window.show()  # IMPORTANT!!!!! Windows are hidden by default.

# Start the event loop.
app.exec()

