#!/bin/bash

SEQUENCE_FILE="$1"

# Sequence and PDB databases
export ALPHAFOLD_DATABASES=/wynton/group/databases/alphafold_CASP14

# Specify which GPU to use.  Important for Wynton cluster queue submissions.
GPU_ID=${SGE_GPU:-0}

# Load the version of CUDA we want.
module load cuda/11.0

singularity exec --nv -B "$ALPHAFOLD_DATABASES" -B "$PWD" /wynton/home/ferrin/goddard/alphafold_singularity/alphafold.sif /opt/alphafold/run.sh -f "$SEQUENCE_FILE" -a $GPU_ID
