# Open an atomic model and close it 100 times and a lot of memory is leaked.
# This makes it hard to run nogui scripts on entire Protein Databank.
#
# Test memory use: chimerax --nogui --silent
# Then command "open test_memleak.py"
#
# Starting chimerax in nogui on macOS 12.4 gives 68 Mbytes memory use reported by Mac Activity Monitor.
# For small structure 17gs (0.38 MB cif file) memory use goes to 145 Mbytes.
# For larger structure 7azs (42 MB cif file) memory use goes to 526 Mbytes.
# For a PDB format file 1s72 (9 MB pdb file) memory use goes to 1450 Mbytes.
# For EMDB map 1080 (4 MB ccp4 file) memory use goes to 71 Mbyte.
# For 7azs opening without adding to open models memory use goes to 280 Mbytes.
#
import tracemalloc
tm_style = 'lineno'
tracemalloc.start(1 if tm_style == 'lineno' else 10)
n = 100
from time import time
from chimerax.core.commands import run
from chimerax.mmcif import open_mmcif
import gc
path = '/Users/goddard/Downloads/ChimeraX/PDB/7azs.cif'
snap1 = tracemalloc.take_snapshot()
for i in range(n):
    t0 = time()
#    models = run(session, 'open 17gs')
    models = run(session, 'open 7azs')
#    models = run(session, 'open 1s72 format pdb')
#    models = run(session, 'open 1080 from emdb')
    session.models.close(models)
#    models = open_mmcif(session, path)[0]
#    for s in models:
#        s.delete()
    run(session, 'wait 1')
    t1 = time()
    if i % 10 == 0:
        print ('%d %.2f' % (i, t1-t0))
#        print ('%d %.2f %d' % (i, t1-t0, len(gc.garbage)))
del models
"""
snap2 = tracemalloc.take_snapshot()
top_stats = snap2.compare_to(snap1, tm_style)
for i, stat in enumerate(top_stats[:5]):
	if tm_style == 'lineno':
		print(f"#{i+1} {stat}")
	else:
		print(f"#{i+1}:")
		for line in stat.traceback.format():
			print(line)
		print()
gc.collect()
from chimerax.atomic.molobject import _weak_refs as wr
alive = [x for x in wr if x() is not None]
print(len(alive), "live references")
import sys
print([(x().__class__.__name__, sys.getrefcount(x())) for x in alive])
"""
